package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccessorResponse(
    accessor: Optional[zio.aws.managedblockchain.model.Accessor] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetAccessorResponse = {
    import GetAccessorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetAccessorResponse
      .builder()
      .optionallyWith(accessor.map(value => value.buildAwsValue()))(_.accessor)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetAccessorResponse.ReadOnly =
    zio.aws.managedblockchain.model.GetAccessorResponse.wrap(buildAwsValue())
}
object GetAccessorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetAccessorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetAccessorResponse =
      zio.aws.managedblockchain.model
        .GetAccessorResponse(accessor.map(value => value.asEditable))
    def accessor: Optional[zio.aws.managedblockchain.model.Accessor.ReadOnly]
    def getAccessor: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.Accessor.ReadOnly
    ] = AwsError.unwrapOptionField("accessor", accessor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetAccessorResponse
  ) extends zio.aws.managedblockchain.model.GetAccessorResponse.ReadOnly {
    override val accessor
        : Optional[zio.aws.managedblockchain.model.Accessor.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessor())
        .map(value => zio.aws.managedblockchain.model.Accessor.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetAccessorResponse
  ): zio.aws.managedblockchain.model.GetAccessorResponse.ReadOnly = new Wrapper(
    impl
  )
}
