package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters.*
sealed trait AccessorType {
  def unwrap
      : software.amazon.awssdk.services.managedblockchain.model.AccessorType
}
object AccessorType {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.AccessorType
  ): zio.aws.managedblockchain.model.AccessorType = value match {
    case software.amazon.awssdk.services.managedblockchain.model.AccessorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.AccessorType.BILLING_TOKEN =>
      val r = BILLING_TOKEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.AccessorType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.AccessorType =
      software.amazon.awssdk.services.managedblockchain.model.AccessorType.UNKNOWN_TO_SDK_VERSION
  }
  case object BILLING_TOKEN
      extends zio.aws.managedblockchain.model.AccessorType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.AccessorType =
      software.amazon.awssdk.services.managedblockchain.model.AccessorType.BILLING_TOKEN
  }
}
