package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNetworksResponse(
    networks: Optional[
      Iterable[zio.aws.managedblockchain.model.NetworkSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse = {
    import ListNetworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse
      .builder()
      .optionallyWith(
        networks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networks)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListNetworksResponse.wrap(buildAwsValue())
}
object ListNetworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListNetworksResponse =
      zio.aws.managedblockchain.model.ListNetworksResponse(
        networks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networks: Optional[
      List[zio.aws.managedblockchain.model.NetworkSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getNetworks: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("networks", networks)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse
  ) extends zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly {
    override val networks: Optional[
      List[zio.aws.managedblockchain.model.NetworkSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchain.model.NetworkSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse
  ): zio.aws.managedblockchain.model.ListNetworksResponse.ReadOnly =
    new Wrapper(impl)
}
