package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAccessorRequest(accessorId: ResourceIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest = {
    import DeleteAccessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest
      .builder()
      .accessorId(ResourceIdString.unwrap(accessorId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.DeleteAccessorRequest.ReadOnly =
    zio.aws.managedblockchain.model.DeleteAccessorRequest.wrap(buildAwsValue())
}
object DeleteAccessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.DeleteAccessorRequest =
      zio.aws.managedblockchain.model.DeleteAccessorRequest(accessorId)
    def accessorId: ResourceIdString
    def getAccessorId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(accessorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest
  ) extends zio.aws.managedblockchain.model.DeleteAccessorRequest.ReadOnly {
    override val accessorId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.accessorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest
  ): zio.aws.managedblockchain.model.DeleteAccessorRequest.ReadOnly =
    new Wrapper(impl)
}
