package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMembersResponse(
    members: Optional[Iterable[zio.aws.managedblockchain.model.MemberSummary]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListMembersResponse =
      zio.aws.managedblockchain.model.ListMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members
        : Optional[List[zio.aws.managedblockchain.model.MemberSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.MemberSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
  ) extends zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly {
    override val members: Optional[
      List[zio.aws.managedblockchain.model.MemberSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchain.model.MemberSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse
  ): zio.aws.managedblockchain.model.ListMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
