package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkFrameworkConfiguration(
    fabric: Optional[
      zio.aws.managedblockchain.model.NetworkFabricConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkConfiguration = {
    import NetworkFrameworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkConfiguration
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NetworkFrameworkConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.NetworkFrameworkConfiguration
      .wrap(buildAwsValue())
}
object NetworkFrameworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchain.model.NetworkFrameworkConfiguration =
      zio.aws.managedblockchain.model
        .NetworkFrameworkConfiguration(fabric.map(value => value.asEditable))
    def fabric: Optional[
      zio.aws.managedblockchain.model.NetworkFabricConfiguration.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkFabricConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkConfiguration
  ) extends zio.aws.managedblockchain.model.NetworkFrameworkConfiguration.ReadOnly {
    override val fabric: Optional[
      zio.aws.managedblockchain.model.NetworkFabricConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkFabricConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkConfiguration
  ): zio.aws.managedblockchain.model.NetworkFrameworkConfiguration.ReadOnly =
    new Wrapper(impl)
}
