package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkFrameworkAttributes(
    fabric: Optional[zio.aws.managedblockchain.model.NetworkFabricAttributes] =
      Optional.Absent,
    ethereum: Optional[
      zio.aws.managedblockchain.model.NetworkEthereumAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes = {
    import NetworkFrameworkAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .optionallyWith(ethereum.map(value => value.buildAwsValue()))(_.ethereum)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NetworkFrameworkAttributes
      .wrap(buildAwsValue())
}
object NetworkFrameworkAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NetworkFrameworkAttributes =
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes(
        fabric.map(value => value.asEditable),
        ethereum.map(value => value.asEditable)
      )
    def fabric: Optional[
      zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly
    ]
    def ethereum: Optional[
      zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
    def getEthereum: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("ethereum", ethereum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
  ) extends zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly {
    override val fabric: Optional[
      zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkFabricAttributes.wrap(value)
      )
    override val ethereum: Optional[
      zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ethereum())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkEthereumAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
  ): zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly =
    new Wrapper(impl)
}
