package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogConfiguration(
    enabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.LogConfiguration = {
    import LogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.LogConfiguration
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.LogConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.LogConfiguration.wrap(buildAwsValue())
}
object LogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.LogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.LogConfiguration =
      zio.aws.managedblockchain.model
        .LogConfiguration(enabled.map(value => value))
    def enabled: Optional[Enabled]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.LogConfiguration
  ) extends zio.aws.managedblockchain.model.LogConfiguration.ReadOnly {
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.managedblockchain.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.LogConfiguration
  ): zio.aws.managedblockchain.model.LogConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
