package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters.*
sealed trait Edition {
  def unwrap: software.amazon.awssdk.services.managedblockchain.model.Edition
}
object Edition {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.Edition
  ): zio.aws.managedblockchain.model.Edition = value match {
    case software.amazon.awssdk.services.managedblockchain.model.Edition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.Edition.STARTER =>
      val r = STARTER
      r
    case software.amazon.awssdk.services.managedblockchain.model.Edition.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.Edition {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.Edition =
      software.amazon.awssdk.services.managedblockchain.model.Edition.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTER extends zio.aws.managedblockchain.model.Edition {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.Edition =
      software.amazon.awssdk.services.managedblockchain.model.Edition.STARTER
  }
  case object STANDARD extends zio.aws.managedblockchain.model.Edition {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.Edition =
      software.amazon.awssdk.services.managedblockchain.model.Edition.STANDARD
  }
}
