package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  TagValue,
  VoteCount,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Proposal(
    proposalId: Optional[ResourceIdString] = Optional.Absent,
    networkId: Optional[ResourceIdString] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    actions: Optional[zio.aws.managedblockchain.model.ProposalActions] =
      Optional.Absent,
    proposedByMemberId: Optional[ResourceIdString] = Optional.Absent,
    proposedByMemberName: Optional[NetworkMemberNameString] = Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.ProposalStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    yesVoteCount: Optional[VoteCount] = Optional.Absent,
    noVoteCount: Optional[VoteCount] = Optional.Absent,
    outstandingVoteCount: Optional[VoteCount] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Proposal = {
    import Proposal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Proposal
      .builder()
      .optionallyWith(
        proposalId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposalId)
      .optionallyWith(
        networkId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.networkId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(actions.map(value => value.buildAwsValue()))(_.actions)
      .optionallyWith(
        proposedByMemberId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberId)
      .optionallyWith(
        proposedByMemberName.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        yesVoteCount.map(value => VoteCount.unwrap(value): Integer)
      )(_.yesVoteCount)
      .optionallyWith(
        noVoteCount.map(value => VoteCount.unwrap(value): Integer)
      )(_.noVoteCount)
      .optionallyWith(
        outstandingVoteCount.map(value => VoteCount.unwrap(value): Integer)
      )(_.outstandingVoteCount)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Proposal.ReadOnly =
    zio.aws.managedblockchain.model.Proposal.wrap(buildAwsValue())
}
object Proposal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Proposal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Proposal =
      zio.aws.managedblockchain.model.Proposal(
        proposalId.map(value => value),
        networkId.map(value => value),
        description.map(value => value),
        actions.map(value => value.asEditable),
        proposedByMemberId.map(value => value),
        proposedByMemberName.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        expirationDate.map(value => value),
        yesVoteCount.map(value => value),
        noVoteCount.map(value => value),
        outstandingVoteCount.map(value => value),
        tags.map(value => value),
        arn.map(value => value)
      )
    def proposalId: Optional[ResourceIdString]
    def networkId: Optional[ResourceIdString]
    def description: Optional[DescriptionString]
    def actions
        : Optional[zio.aws.managedblockchain.model.ProposalActions.ReadOnly]
    def proposedByMemberId: Optional[ResourceIdString]
    def proposedByMemberName: Optional[NetworkMemberNameString]
    def status: Optional[zio.aws.managedblockchain.model.ProposalStatus]
    def creationDate: Optional[Timestamp]
    def expirationDate: Optional[Timestamp]
    def yesVoteCount: Optional[VoteCount]
    def noVoteCount: Optional[VoteCount]
    def outstandingVoteCount: Optional[VoteCount]
    def tags: Optional[Map[TagKey, TagValue]]
    def arn: Optional[ArnString]
    def getProposalId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposalId", proposalId)
    def getNetworkId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getActions: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.ProposalActions.ReadOnly
    ] = AwsError.unwrapOptionField("actions", actions)
    def getProposedByMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposedByMemberId", proposedByMemberId)
    def getProposedByMemberName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("proposedByMemberName", proposedByMemberName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.ProposalStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getYesVoteCount: ZIO[Any, AwsError, VoteCount] =
      AwsError.unwrapOptionField("yesVoteCount", yesVoteCount)
    def getNoVoteCount: ZIO[Any, AwsError, VoteCount] =
      AwsError.unwrapOptionField("noVoteCount", noVoteCount)
    def getOutstandingVoteCount: ZIO[Any, AwsError, VoteCount] =
      AwsError.unwrapOptionField("outstandingVoteCount", outstandingVoteCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Proposal
  ) extends zio.aws.managedblockchain.model.Proposal.ReadOnly {
    override val proposalId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.proposalId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val networkId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.networkId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.DescriptionString(value)
        )
    override val actions
        : Optional[zio.aws.managedblockchain.model.ProposalActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actions())
        .map(value =>
          zio.aws.managedblockchain.model.ProposalActions.wrap(value)
        )
    override val proposedByMemberId: Optional[ResourceIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposedByMemberId())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
        )
    override val proposedByMemberName: Optional[NetworkMemberNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposedByMemberName())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .NetworkMemberNameString(value)
        )
    override val status
        : Optional[zio.aws.managedblockchain.model.ProposalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.managedblockchain.model.ProposalStatus.wrap(value)
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val yesVoteCount: Optional[VoteCount] = zio.aws.core.internal
      .optionalFromNullable(impl.yesVoteCount())
      .map(value => zio.aws.managedblockchain.model.primitives.VoteCount(value))
    override val noVoteCount: Optional[VoteCount] = zio.aws.core.internal
      .optionalFromNullable(impl.noVoteCount())
      .map(value => zio.aws.managedblockchain.model.primitives.VoteCount(value))
    override val outstandingVoteCount: Optional[VoteCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outstandingVoteCount())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.VoteCount(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Proposal
  ): zio.aws.managedblockchain.model.Proposal.ReadOnly = new Wrapper(impl)
}
