package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  FrameworkVersionString,
  Timestamp,
  TagValue,
  ResourceIdString,
  NameString,
  DescriptionString,
  ArnString,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Network(
    id: Optional[ResourceIdString] = Optional.Absent,
    name: Optional[NameString] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    framework: Optional[zio.aws.managedblockchain.model.Framework] =
      Optional.Absent,
    frameworkVersion: Optional[FrameworkVersionString] = Optional.Absent,
    frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes
    ] = Optional.Absent,
    vpcEndpointServiceName: Optional[String] = Optional.Absent,
    votingPolicy: Optional[zio.aws.managedblockchain.model.VotingPolicy] =
      Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.NetworkStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Network = {
    import Network.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Network
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(framework.map(value => value.unwrap))(_.framework)
      .optionallyWith(
        frameworkVersion.map(value =>
          FrameworkVersionString.unwrap(value): java.lang.String
        )
      )(_.frameworkVersion)
      .optionallyWith(frameworkAttributes.map(value => value.buildAwsValue()))(
        _.frameworkAttributes
      )
      .optionallyWith(
        vpcEndpointServiceName.map(value => value: java.lang.String)
      )(_.vpcEndpointServiceName)
      .optionallyWith(votingPolicy.map(value => value.buildAwsValue()))(
        _.votingPolicy
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Network.ReadOnly =
    zio.aws.managedblockchain.model.Network.wrap(buildAwsValue())
}
object Network {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Network
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Network =
      zio.aws.managedblockchain.model.Network(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        framework.map(value => value),
        frameworkVersion.map(value => value),
        frameworkAttributes.map(value => value.asEditable),
        vpcEndpointServiceName.map(value => value),
        votingPolicy.map(value => value.asEditable),
        status.map(value => value),
        creationDate.map(value => value),
        tags.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[ResourceIdString]
    def name: Optional[NameString]
    def description: Optional[DescriptionString]
    def framework: Optional[zio.aws.managedblockchain.model.Framework]
    def frameworkVersion: Optional[FrameworkVersionString]
    def frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly
    ]
    def vpcEndpointServiceName: Optional[String]
    def votingPolicy
        : Optional[zio.aws.managedblockchain.model.VotingPolicy.ReadOnly]
    def status: Optional[zio.aws.managedblockchain.model.NetworkStatus]
    def creationDate: Optional[Timestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def arn: Optional[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFramework
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getFrameworkVersion: ZIO[Any, AwsError, FrameworkVersionString] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
    def getFrameworkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("frameworkAttributes", frameworkAttributes)
    def getVpcEndpointServiceName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcEndpointServiceName", vpcEndpointServiceName)
    def getVotingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.VotingPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("votingPolicy", votingPolicy)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NetworkStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Network
  ) extends zio.aws.managedblockchain.model.Network.ReadOnly {
    override val id: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.NameString(value)
      )
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.DescriptionString(value)
        )
    override val framework
        : Optional[zio.aws.managedblockchain.model.Framework] =
      zio.aws.core.internal
        .optionalFromNullable(impl.framework())
        .map(value => zio.aws.managedblockchain.model.Framework.wrap(value))
    override val frameworkVersion: Optional[FrameworkVersionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkVersion())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .FrameworkVersionString(value)
        )
    override val frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkAttributes())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkFrameworkAttributes.wrap(value)
      )
    override val vpcEndpointServiceName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointServiceName())
        .map(value => value: String)
    override val votingPolicy
        : Optional[zio.aws.managedblockchain.model.VotingPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.votingPolicy())
        .map(value => zio.aws.managedblockchain.model.VotingPolicy.wrap(value))
    override val status
        : Optional[zio.aws.managedblockchain.model.NetworkStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.managedblockchain.model.NetworkStatus.wrap(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Network
  ): zio.aws.managedblockchain.model.Network.ReadOnly = new Wrapper(impl)
}
