package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkFabricAttributes(
    orderingServiceEndpoint: Optional[String] = Optional.Absent,
    edition: Optional[zio.aws.managedblockchain.model.Edition] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkFabricAttributes = {
    import NetworkFabricAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkFabricAttributes
      .builder()
      .optionallyWith(
        orderingServiceEndpoint.map(value => value: java.lang.String)
      )(_.orderingServiceEndpoint)
      .optionallyWith(edition.map(value => value.unwrap))(_.edition)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NetworkFabricAttributes
      .wrap(buildAwsValue())
}
object NetworkFabricAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkFabricAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NetworkFabricAttributes =
      zio.aws.managedblockchain.model.NetworkFabricAttributes(
        orderingServiceEndpoint.map(value => value),
        edition.map(value => value)
      )
    def orderingServiceEndpoint: Optional[String]
    def edition: Optional[zio.aws.managedblockchain.model.Edition]
    def getOrderingServiceEndpoint: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("orderingServiceEndpoint", orderingServiceEndpoint)
    def getEdition
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Edition] =
      AwsError.unwrapOptionField("edition", edition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFabricAttributes
  ) extends zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly {
    override val orderingServiceEndpoint: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderingServiceEndpoint())
        .map(value => value: String)
    override val edition: Optional[zio.aws.managedblockchain.model.Edition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edition())
        .map(value => zio.aws.managedblockchain.model.Edition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFabricAttributes
  ): zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly =
    new Wrapper(impl)
}
