package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMemberResponse(
    member: Optional[zio.aws.managedblockchain.model.Member] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse = {
    import GetMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetMemberResponse.ReadOnly =
    zio.aws.managedblockchain.model.GetMemberResponse.wrap(buildAwsValue())
}
object GetMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetMemberResponse =
      zio.aws.managedblockchain.model
        .GetMemberResponse(member.map(value => value.asEditable))
    def member: Optional[zio.aws.managedblockchain.model.Member.ReadOnly]
    def getMember
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Member.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse
  ) extends zio.aws.managedblockchain.model.GetMemberResponse.ReadOnly {
    override val member
        : Optional[zio.aws.managedblockchain.model.Member.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.managedblockchain.model.Member.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse
  ): zio.aws.managedblockchain.model.GetMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
