package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MemberFabricLogPublishingConfiguration(
    caLogs: Optional[zio.aws.managedblockchain.model.LogConfigurations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberFabricLogPublishingConfiguration = {
    import MemberFabricLogPublishingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberFabricLogPublishingConfiguration
      .builder()
      .optionallyWith(caLogs.map(value => value.buildAwsValue()))(_.caLogs)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration
      .wrap(buildAwsValue())
}
object MemberFabricLogPublishingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberFabricLogPublishingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration =
      zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration(
        caLogs.map(value => value.asEditable)
      )
    def caLogs
        : Optional[zio.aws.managedblockchain.model.LogConfigurations.ReadOnly]
    def getCaLogs: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.LogConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("caLogs", caLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFabricLogPublishingConfiguration
  ) extends zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration.ReadOnly {
    override val caLogs
        : Optional[zio.aws.managedblockchain.model.LogConfigurations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caLogs())
        .map(value =>
          zio.aws.managedblockchain.model.LogConfigurations.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFabricLogPublishingConfiguration
  ): zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration.ReadOnly =
    new Wrapper(impl)
}
