package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNodeResponse(
    node: Optional[zio.aws.managedblockchain.model.Node] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse = {
    import GetNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse
      .builder()
      .optionallyWith(node.map(value => value.buildAwsValue()))(_.node)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly =
    zio.aws.managedblockchain.model.GetNodeResponse.wrap(buildAwsValue())
}
object GetNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetNodeResponse =
      zio.aws.managedblockchain.model
        .GetNodeResponse(node.map(value => value.asEditable))
    def node: Optional[zio.aws.managedblockchain.model.Node.ReadOnly]
    def getNode
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Node.ReadOnly] =
      AwsError.unwrapOptionField("node", node)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse
  ) extends zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly {
    override val node: Optional[zio.aws.managedblockchain.model.Node.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.node())
        .map(value => zio.aws.managedblockchain.model.Node.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse
  ): zio.aws.managedblockchain.model.GetNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
