package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{TagValue, TagKey, ArnString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ArnString,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest
      .builder()
      .resourceArn(ArnString.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.TagResourceRequest.ReadOnly =
    zio.aws.managedblockchain.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.TagResourceRequest =
      zio.aws.managedblockchain.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ArnString
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ArnString] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest
  ) extends zio.aws.managedblockchain.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ArnString =
      zio.aws.managedblockchain.model.primitives.ArnString(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.managedblockchain.model.primitives.TagKey(
          key
        ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest
  ): zio.aws.managedblockchain.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
