package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  TagValue,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Member(
    networkId: Optional[ResourceIdString] = Optional.Absent,
    id: Optional[ResourceIdString] = Optional.Absent,
    name: Optional[NetworkMemberNameString] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.MemberFrameworkAttributes
    ] = Optional.Absent,
    logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
    ] = Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.MemberStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent,
    kmsKeyArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Member
      .builder()
      .optionallyWith(
        networkId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.networkId)
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(frameworkAttributes.map(value => value.buildAwsValue()))(
        _.frameworkAttributes
      )
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Member.ReadOnly =
    zio.aws.managedblockchain.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Member
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Member =
      zio.aws.managedblockchain.model.Member(
        networkId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        frameworkAttributes.map(value => value.asEditable),
        logPublishingConfiguration.map(value => value.asEditable),
        status.map(value => value),
        creationDate.map(value => value),
        tags.map(value => value),
        arn.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def networkId: Optional[ResourceIdString]
    def id: Optional[ResourceIdString]
    def name: Optional[NetworkMemberNameString]
    def description: Optional[DescriptionString]
    def frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly
    ]
    def logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ]
    def status: Optional[zio.aws.managedblockchain.model.MemberStatus]
    def creationDate: Optional[Timestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def arn: Optional[ArnString]
    def kmsKeyArn: Optional[String]
    def getNetworkId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFrameworkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("frameworkAttributes", frameworkAttributes)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Member
  ) extends zio.aws.managedblockchain.model.Member.ReadOnly {
    override val networkId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.networkId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val id: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Optional[NetworkMemberNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.DescriptionString(value)
        )
    override val frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkAttributes())
      .map(value =>
        zio.aws.managedblockchain.model.MemberFrameworkAttributes.wrap(value)
      )
    override val logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
          .wrap(value)
      )
    override val status
        : Optional[zio.aws.managedblockchain.model.MemberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.managedblockchain.model.MemberStatus.wrap(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
    override val kmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Member
  ): zio.aws.managedblockchain.model.Member.ReadOnly = new Wrapper(impl)
}
