package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  NodeListMaxResults,
  ResourceIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNodesRequest(
    networkId: ResourceIdString,
    memberId: Option[ResourceIdString] = None,
    status: Option[zio.aws.managedblockchain.model.NodeStatus] = None,
    maxResults: Option[NodeListMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest = {
    import ListNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxResults.map(value => NodeListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListNodesRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListNodesRequest.wrap(buildAwsValue())
}
object ListNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListNodesRequest =
      zio.aws.managedblockchain.model.ListNodesRequest(
        networkId,
        memberId.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkId: ResourceIdString
    def memberId: Option[ResourceIdString]
    def status: Option[zio.aws.managedblockchain.model.NodeStatus]
    def maxResults: Option[NodeListMaxResults]
    def nextToken: Option[PaginationToken]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NodeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, NodeListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest
  ) extends zio.aws.managedblockchain.model.ListNodesRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: Option[ResourceIdString] = scala
      .Option(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val status: Option[zio.aws.managedblockchain.model.NodeStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.NodeStatus.wrap(value))
    override val maxResults: Option[NodeListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.NodeListMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest
  ): zio.aws.managedblockchain.model.ListNodesRequest.ReadOnly = new Wrapper(
    impl
  )
}
