package zio.aws.managedblockchain
import zio.prelude.Subtype
import zio.aws.managedblockchain.model.primitives.{TagValue, TagKey}
import java.time.Instant
import zio.aws.managedblockchain.model.primitives.IsOwned.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ArnString extends Subtype[String]
    type ArnString = zio.aws.managedblockchain.model.primitives.ArnString.Type
    object AvailabilityZoneString extends Subtype[String]
    type AvailabilityZoneString =
      zio.aws.managedblockchain.model.primitives.AvailabilityZoneString.Type
    object ClientRequestTokenString extends Subtype[String]
    type ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives.ClientRequestTokenString.Type
    object DescriptionString extends Subtype[String]
    type DescriptionString =
      zio.aws.managedblockchain.model.primitives.DescriptionString.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.managedblockchain.model.primitives.Enabled.Type
    object FrameworkVersionString extends Subtype[String]
    type FrameworkVersionString =
      zio.aws.managedblockchain.model.primitives.FrameworkVersionString.Type
    object InstanceTypeString extends Subtype[String]
    type InstanceTypeString =
      zio.aws.managedblockchain.model.primitives.InstanceTypeString.Type
    object IsOwned extends Subtype[Boolean]
    type IsOwned = zio.aws.managedblockchain.model.primitives.IsOwned.Type
    object MemberListMaxResults extends Subtype[Int]
    type MemberListMaxResults =
      zio.aws.managedblockchain.model.primitives.MemberListMaxResults.Type
    object NameString extends Subtype[String]
    type NameString = zio.aws.managedblockchain.model.primitives.NameString.Type
    object NetworkListMaxResults extends Subtype[Int]
    type NetworkListMaxResults =
      zio.aws.managedblockchain.model.primitives.NetworkListMaxResults.Type
    object NetworkMemberNameString extends Subtype[String]
    type NetworkMemberNameString =
      zio.aws.managedblockchain.model.primitives.NetworkMemberNameString.Type
    object NodeListMaxResults extends Subtype[Int]
    type NodeListMaxResults =
      zio.aws.managedblockchain.model.primitives.NodeListMaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.managedblockchain.model.primitives.PaginationToken.Type
    object PasswordString extends Subtype[String]
    type PasswordString =
      zio.aws.managedblockchain.model.primitives.PasswordString.Type
    object PrincipalString extends Subtype[String]
    type PrincipalString =
      zio.aws.managedblockchain.model.primitives.PrincipalString.Type
    object ProposalDurationInt extends Subtype[Int]
    type ProposalDurationInt =
      zio.aws.managedblockchain.model.primitives.ProposalDurationInt.Type
    object ProposalListMaxResults extends Subtype[Int]
    type ProposalListMaxResults =
      zio.aws.managedblockchain.model.primitives.ProposalListMaxResults.Type
    object ResourceIdString extends Subtype[String]
    type ResourceIdString =
      zio.aws.managedblockchain.model.primitives.ResourceIdString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.managedblockchain.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.managedblockchain.model.primitives.TagValue.Type
    object ThresholdPercentageInt extends Subtype[Int]
    type ThresholdPercentageInt =
      zio.aws.managedblockchain.model.primitives.ThresholdPercentageInt.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.managedblockchain.model.primitives.Timestamp.Type
    object UsernameString extends Subtype[String]
    type UsernameString =
      zio.aws.managedblockchain.model.primitives.UsernameString.Type
    object VoteCount extends Subtype[Int]
    type VoteCount = zio.aws.managedblockchain.model.primitives.VoteCount.Type
  }
  type InputTagMap = Map[TagKey, TagValue]
  type InvitationList = List[zio.aws.managedblockchain.model.Invitation]
  type InviteActionList = List[zio.aws.managedblockchain.model.InviteAction]
  type MemberSummaryList = List[zio.aws.managedblockchain.model.MemberSummary]
  type NetworkSummaryList = List[zio.aws.managedblockchain.model.NetworkSummary]
  type NodeSummaryList = List[zio.aws.managedblockchain.model.NodeSummary]
  type OutputTagMap = Map[TagKey, TagValue]
  type ProposalSummaryList =
    List[zio.aws.managedblockchain.model.ProposalSummary]
  type ProposalVoteList = List[zio.aws.managedblockchain.model.VoteSummary]
  type RemoveActionList = List[zio.aws.managedblockchain.model.RemoveAction]
  type TagKeyList = List[TagKey]
}
