package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  IsOwned,
  Timestamp,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MemberSummary(
    id: Option[ResourceIdString] = None,
    name: Option[NetworkMemberNameString] = None,
    description: Option[DescriptionString] = None,
    status: Option[zio.aws.managedblockchain.model.MemberStatus] = None,
    creationDate: Option[Timestamp] = None,
    isOwned: Option[IsOwned] = None,
    arn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberSummary = {
    import MemberSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberSummary
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        isOwned.map(value => IsOwned.unwrap(value): java.lang.Boolean)
      )(_.isOwned)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.MemberSummary.ReadOnly =
    zio.aws.managedblockchain.model.MemberSummary.wrap(buildAwsValue())
}
object MemberSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.MemberSummary =
      zio.aws.managedblockchain.model.MemberSummary(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        isOwned.map(value => value),
        arn.map(value => value)
      )
    def id: Option[ResourceIdString]
    def name: Option[NetworkMemberNameString]
    def description: Option[DescriptionString]
    def status: Option[zio.aws.managedblockchain.model.MemberStatus]
    def creationDate: Option[Timestamp]
    def isOwned: Option[IsOwned]
    def arn: Option[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getIsOwned: ZIO[Any, AwsError, IsOwned] =
      AwsError.unwrapOptionField("isOwned", isOwned)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberSummary
  ) extends zio.aws.managedblockchain.model.MemberSummary.ReadOnly {
    override val id: Option[ResourceIdString] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Option[NetworkMemberNameString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val status: Option[zio.aws.managedblockchain.model.MemberStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.MemberStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val isOwned: Option[IsOwned] = scala
      .Option(impl.isOwned())
      .map(value => zio.aws.managedblockchain.model.primitives.IsOwned(value))
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberSummary
  ): zio.aws.managedblockchain.model.MemberSummary.ReadOnly = new Wrapper(impl)
}
