package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateNetworkResponse(
    networkId: Option[ResourceIdString] = None,
    memberId: Option[ResourceIdString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse = {
    import CreateNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse
      .builder()
      .optionallyWith(
        networkId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.networkId)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly =
    zio.aws.managedblockchain.model.CreateNetworkResponse.wrap(buildAwsValue())
}
object CreateNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateNetworkResponse =
      zio.aws.managedblockchain.model.CreateNetworkResponse(
        networkId.map(value => value),
        memberId.map(value => value)
      )
    def networkId: Option[ResourceIdString]
    def memberId: Option[ResourceIdString]
    def getNetworkId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse
  ) extends zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly {
    override val networkId: Option[ResourceIdString] = scala
      .Option(impl.networkId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val memberId: Option[ResourceIdString] = scala
      .Option(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse
  ): zio.aws.managedblockchain.model.CreateNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
