package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetProposalResponse(
    proposal: Option[zio.aws.managedblockchain.model.Proposal] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse = {
    import GetProposalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse
      .builder()
      .optionallyWith(proposal.map(value => value.buildAwsValue()))(_.proposal)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly =
    zio.aws.managedblockchain.model.GetProposalResponse.wrap(buildAwsValue())
}
object GetProposalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetProposalResponse =
      zio.aws.managedblockchain.model
        .GetProposalResponse(proposal.map(value => value.asEditable))
    def proposal: Option[zio.aws.managedblockchain.model.Proposal.ReadOnly]
    def getProposal: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.Proposal.ReadOnly
    ] = AwsError.unwrapOptionField("proposal", proposal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse
  ) extends zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly {
    override val proposal
        : Option[zio.aws.managedblockchain.model.Proposal.ReadOnly] = scala
      .Option(impl.proposal())
      .map(value => zio.aws.managedblockchain.model.Proposal.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse
  ): zio.aws.managedblockchain.model.GetProposalResponse.ReadOnly = new Wrapper(
    impl
  )
}
