package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkEthereumAttributes(chainId: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkEthereumAttributes = {
    import NetworkEthereumAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkEthereumAttributes
      .builder()
      .optionallyWith(chainId.map(value => value: java.lang.String))(_.chainId)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NetworkEthereumAttributes
      .wrap(buildAwsValue())
}
object NetworkEthereumAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkEthereumAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NetworkEthereumAttributes =
      zio.aws.managedblockchain.model
        .NetworkEthereumAttributes(chainId.map(value => value))
    def chainId: Option[String]
    def getChainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("chainId", chainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkEthereumAttributes
  ) extends zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly {
    override val chainId: Option[String] =
      scala.Option(impl.chainId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkEthereumAttributes
  ): zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly =
    new Wrapper(impl)
}
