package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{TagKey, ArnString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: ArnString,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest
      .builder()
      .resourceArn(ArnString.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.UntagResourceRequest.ReadOnly =
    zio.aws.managedblockchain.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.UntagResourceRequest =
      zio.aws.managedblockchain.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ArnString
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ArnString] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest
  ) extends zio.aws.managedblockchain.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ArnString =
      zio.aws.managedblockchain.model.primitives.ArnString(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.managedblockchain.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest
  ): zio.aws.managedblockchain.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
