package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  FrameworkVersionString,
  Timestamp,
  ResourceIdString,
  NameString,
  DescriptionString,
  ArnString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class NetworkSummary(
    id: Option[ResourceIdString] = None,
    name: Option[NameString] = None,
    description: Option[DescriptionString] = None,
    framework: Option[zio.aws.managedblockchain.model.Framework] = None,
    frameworkVersion: Option[FrameworkVersionString] = None,
    status: Option[zio.aws.managedblockchain.model.NetworkStatus] = None,
    creationDate: Option[Timestamp] = None,
    arn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkSummary = {
    import NetworkSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkSummary
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(framework.map(value => value.unwrap))(_.framework)
      .optionallyWith(
        frameworkVersion.map(value =>
          FrameworkVersionString.unwrap(value): java.lang.String
        )
      )(_.frameworkVersion)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.NetworkSummary.ReadOnly =
    zio.aws.managedblockchain.model.NetworkSummary.wrap(buildAwsValue())
}
object NetworkSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NetworkSummary =
      zio.aws.managedblockchain.model.NetworkSummary(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        framework.map(value => value),
        frameworkVersion.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        arn.map(value => value)
      )
    def id: Option[ResourceIdString]
    def name: Option[NameString]
    def description: Option[DescriptionString]
    def framework: Option[zio.aws.managedblockchain.model.Framework]
    def frameworkVersion: Option[FrameworkVersionString]
    def status: Option[zio.aws.managedblockchain.model.NetworkStatus]
    def creationDate: Option[Timestamp]
    def arn: Option[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getFramework
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getFrameworkVersion: ZIO[Any, AwsError, FrameworkVersionString] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NetworkStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkSummary
  ) extends zio.aws.managedblockchain.model.NetworkSummary.ReadOnly {
    override val id: Option[ResourceIdString] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val name: Option[NameString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.NameString(value)
      )
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val framework: Option[zio.aws.managedblockchain.model.Framework] =
      scala
        .Option(impl.framework())
        .map(value => zio.aws.managedblockchain.model.Framework.wrap(value))
    override val frameworkVersion: Option[FrameworkVersionString] = scala
      .Option(impl.frameworkVersion())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.FrameworkVersionString(value)
      )
    override val status: Option[zio.aws.managedblockchain.model.NetworkStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.NetworkStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkSummary
  ): zio.aws.managedblockchain.model.NetworkSummary.ReadOnly = new Wrapper(impl)
}
