package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInvitationsResponse(
    invitations: Option[Iterable[zio.aws.managedblockchain.model.Invitation]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse = {
    import ListInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse
      .builder()
      .optionallyWith(
        invitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invitations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListInvitationsResponse
      .wrap(buildAwsValue())
}
object ListInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListInvitationsResponse =
      zio.aws.managedblockchain.model.ListInvitationsResponse(
        invitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def invitations
        : Option[List[zio.aws.managedblockchain.model.Invitation.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getInvitations: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.Invitation.ReadOnly
    ]] = AwsError.unwrapOptionField("invitations", invitations)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse
  ) extends zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly {
    override val invitations
        : Option[List[zio.aws.managedblockchain.model.Invitation.ReadOnly]] =
      scala
        .Option(impl.invitations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.managedblockchain.model.Invitation.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse
  ): zio.aws.managedblockchain.model.ListInvitationsResponse.ReadOnly =
    new Wrapper(impl)
}
