package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  ResourceIdString,
  NetworkMemberNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VoteSummary(
    vote: Option[zio.aws.managedblockchain.model.VoteValue] = None,
    memberName: Option[NetworkMemberNameString] = None,
    memberId: Option[ResourceIdString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.VoteSummary = {
    import VoteSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.VoteSummary
      .builder()
      .optionallyWith(vote.map(value => value.unwrap))(_.vote)
      .optionallyWith(
        memberName.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.memberName)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.VoteSummary.ReadOnly =
    zio.aws.managedblockchain.model.VoteSummary.wrap(buildAwsValue())
}
object VoteSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.VoteSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.VoteSummary =
      zio.aws.managedblockchain.model.VoteSummary(
        vote.map(value => value),
        memberName.map(value => value),
        memberId.map(value => value)
      )
    def vote: Option[zio.aws.managedblockchain.model.VoteValue]
    def memberName: Option[NetworkMemberNameString]
    def memberId: Option[ResourceIdString]
    def getVote: ZIO[Any, AwsError, zio.aws.managedblockchain.model.VoteValue] =
      AwsError.unwrapOptionField("vote", vote)
    def getMemberName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("memberName", memberName)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.VoteSummary
  ) extends zio.aws.managedblockchain.model.VoteSummary.ReadOnly {
    override val vote: Option[zio.aws.managedblockchain.model.VoteValue] = scala
      .Option(impl.vote())
      .map(value => zio.aws.managedblockchain.model.VoteValue.wrap(value))
    override val memberName: Option[NetworkMemberNameString] = scala
      .Option(impl.memberName())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val memberId: Option[ResourceIdString] = scala
      .Option(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.VoteSummary
  ): zio.aws.managedblockchain.model.VoteSummary.ReadOnly = new Wrapper(impl)
}
