package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  ResourceIdString,
  AvailabilityZoneString,
  InstanceTypeString,
  ArnString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class NodeSummary(
    id: Option[ResourceIdString] = None,
    status: Option[zio.aws.managedblockchain.model.NodeStatus] = None,
    creationDate: Option[Timestamp] = None,
    availabilityZone: Option[AvailabilityZoneString] = None,
    instanceType: Option[InstanceTypeString] = None,
    arn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeSummary = {
    import NodeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeSummary
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZoneString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        instanceType.map(value =>
          InstanceTypeString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.NodeSummary.ReadOnly =
    zio.aws.managedblockchain.model.NodeSummary.wrap(buildAwsValue())
}
object NodeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NodeSummary =
      zio.aws.managedblockchain.model.NodeSummary(
        id.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        availabilityZone.map(value => value),
        instanceType.map(value => value),
        arn.map(value => value)
      )
    def id: Option[ResourceIdString]
    def status: Option[zio.aws.managedblockchain.model.NodeStatus]
    def creationDate: Option[Timestamp]
    def availabilityZone: Option[AvailabilityZoneString]
    def instanceType: Option[InstanceTypeString]
    def arn: Option[ArnString]
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NodeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZoneString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstanceType: ZIO[Any, AwsError, InstanceTypeString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeSummary
  ) extends zio.aws.managedblockchain.model.NodeSummary.ReadOnly {
    override val id: Option[ResourceIdString] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val status: Option[zio.aws.managedblockchain.model.NodeStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.NodeStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val availabilityZone: Option[AvailabilityZoneString] = scala
      .Option(impl.availabilityZone())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.AvailabilityZoneString(value)
      )
    override val instanceType: Option[InstanceTypeString] = scala
      .Option(impl.instanceType())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.InstanceTypeString(value)
      )
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeSummary
  ): zio.aws.managedblockchain.model.NodeSummary.ReadOnly = new Wrapper(impl)
}
