package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  ProposalListMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInvitationsRequest(
    maxResults: Option[ProposalListMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest = {
    import ListInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ProposalListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListInvitationsRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListInvitationsRequest.wrap(buildAwsValue())
}
object ListInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListInvitationsRequest =
      zio.aws.managedblockchain.model.ListInvitationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ProposalListMaxResults]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, ProposalListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest
  ) extends zio.aws.managedblockchain.model.ListInvitationsRequest.ReadOnly {
    override val maxResults: Option[ProposalListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ProposalListMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest
  ): zio.aws.managedblockchain.model.ListInvitationsRequest.ReadOnly =
    new Wrapper(impl)
}
