package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NodeFabricLogPublishingConfiguration(
    chaincodeLogs: Option[zio.aws.managedblockchain.model.LogConfigurations] =
      None,
    peerLogs: Option[zio.aws.managedblockchain.model.LogConfigurations] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeFabricLogPublishingConfiguration = {
    import NodeFabricLogPublishingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeFabricLogPublishingConfiguration
      .builder()
      .optionallyWith(chaincodeLogs.map(value => value.buildAwsValue()))(
        _.chaincodeLogs
      )
      .optionallyWith(peerLogs.map(value => value.buildAwsValue()))(_.peerLogs)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration
      .wrap(buildAwsValue())
}
object NodeFabricLogPublishingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeFabricLogPublishingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration =
      zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration(
        chaincodeLogs.map(value => value.asEditable),
        peerLogs.map(value => value.asEditable)
      )
    def chaincodeLogs
        : Option[zio.aws.managedblockchain.model.LogConfigurations.ReadOnly]
    def peerLogs
        : Option[zio.aws.managedblockchain.model.LogConfigurations.ReadOnly]
    def getChaincodeLogs: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.LogConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("chaincodeLogs", chaincodeLogs)
    def getPeerLogs: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.LogConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("peerLogs", peerLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeFabricLogPublishingConfiguration
  ) extends zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration.ReadOnly {
    override val chaincodeLogs
        : Option[zio.aws.managedblockchain.model.LogConfigurations.ReadOnly] =
      scala
        .Option(impl.chaincodeLogs())
        .map(value =>
          zio.aws.managedblockchain.model.LogConfigurations.wrap(value)
        )
    override val peerLogs
        : Option[zio.aws.managedblockchain.model.LogConfigurations.ReadOnly] =
      scala
        .Option(impl.peerLogs())
        .map(value =>
          zio.aws.managedblockchain.model.LogConfigurations.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeFabricLogPublishingConfiguration
  ): zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration.ReadOnly =
    new Wrapper(impl)
}
