package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NodeLogPublishingConfiguration(
    fabric: Option[
      zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration = {
    import NodeLogPublishingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
      .wrap(buildAwsValue())
}
object NodeLogPublishingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchain.model.NodeLogPublishingConfiguration =
      zio.aws.managedblockchain.model
        .NodeLogPublishingConfiguration(fabric.map(value => value.asEditable))
    def fabric: Option[
      zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration
  ) extends zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly {
    override val fabric: Option[
      zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration.ReadOnly
    ] = scala
      .Option(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.NodeFabricLogPublishingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration
  ): zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly =
    new Wrapper(impl)
}
