package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  NetworkListMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNetworksRequest(
    name: Option[String] = None,
    framework: Option[zio.aws.managedblockchain.model.Framework] = None,
    status: Option[zio.aws.managedblockchain.model.NetworkStatus] = None,
    maxResults: Option[NetworkListMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest = {
    import ListNetworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(framework.map(value => value.unwrap))(_.framework)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxResults.map(value => NetworkListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListNetworksRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListNetworksRequest.wrap(buildAwsValue())
}
object ListNetworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListNetworksRequest =
      zio.aws.managedblockchain.model.ListNetworksRequest(
        name.map(value => value),
        framework.map(value => value),
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: Option[String]
    def framework: Option[zio.aws.managedblockchain.model.Framework]
    def status: Option[zio.aws.managedblockchain.model.NetworkStatus]
    def maxResults: Option[NetworkListMaxResults]
    def nextToken: Option[PaginationToken]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getFramework
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NetworkStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, NetworkListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest
  ) extends zio.aws.managedblockchain.model.ListNetworksRequest.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val framework: Option[zio.aws.managedblockchain.model.Framework] =
      scala
        .Option(impl.framework())
        .map(value => zio.aws.managedblockchain.model.Framework.wrap(value))
    override val status: Option[zio.aws.managedblockchain.model.NetworkStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.managedblockchain.model.NetworkStatus.wrap(value))
    override val maxResults: Option[NetworkListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.NetworkListMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest
  ): zio.aws.managedblockchain.model.ListNetworksRequest.ReadOnly = new Wrapper(
    impl
  )
}
