package zio.aws.managedblockchain.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  TagValue,
  VoteCount,
  ResourceIdString,
  NetworkMemberNameString,
  DescriptionString,
  ArnString,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Proposal(
    proposalId: Option[ResourceIdString] = None,
    networkId: Option[ResourceIdString] = None,
    description: Option[DescriptionString] = None,
    actions: Option[zio.aws.managedblockchain.model.ProposalActions] = None,
    proposedByMemberId: Option[ResourceIdString] = None,
    proposedByMemberName: Option[NetworkMemberNameString] = None,
    status: Option[zio.aws.managedblockchain.model.ProposalStatus] = None,
    creationDate: Option[Timestamp] = None,
    expirationDate: Option[Timestamp] = None,
    yesVoteCount: Option[VoteCount] = None,
    noVoteCount: Option[VoteCount] = None,
    outstandingVoteCount: Option[VoteCount] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    arn: Option[ArnString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Proposal = {
    import Proposal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Proposal
      .builder()
      .optionallyWith(
        proposalId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposalId)
      .optionallyWith(
        networkId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.networkId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(actions.map(value => value.buildAwsValue()))(_.actions)
      .optionallyWith(
        proposedByMemberId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberId)
      .optionallyWith(
        proposedByMemberName.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.proposedByMemberName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        yesVoteCount.map(value => VoteCount.unwrap(value): Integer)
      )(_.yesVoteCount)
      .optionallyWith(
        noVoteCount.map(value => VoteCount.unwrap(value): Integer)
      )(_.noVoteCount)
      .optionallyWith(
        outstandingVoteCount.map(value => VoteCount.unwrap(value): Integer)
      )(_.outstandingVoteCount)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Proposal.ReadOnly =
    zio.aws.managedblockchain.model.Proposal.wrap(buildAwsValue())
}
object Proposal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Proposal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Proposal =
      zio.aws.managedblockchain.model.Proposal(
        proposalId.map(value => value),
        networkId.map(value => value),
        description.map(value => value),
        actions.map(value => value.asEditable),
        proposedByMemberId.map(value => value),
        proposedByMemberName.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        expirationDate.map(value => value),
        yesVoteCount.map(value => value),
        noVoteCount.map(value => value),
        outstandingVoteCount.map(value => value),
        tags.map(value => value),
        arn.map(value => value)
      )
    def proposalId: Option[ResourceIdString]
    def networkId: Option[ResourceIdString]
    def description: Option[DescriptionString]
    def actions
        : Option[zio.aws.managedblockchain.model.ProposalActions.ReadOnly]
    def proposedByMemberId: Option[ResourceIdString]
    def proposedByMemberName: Option[NetworkMemberNameString]
    def status: Option[zio.aws.managedblockchain.model.ProposalStatus]
    def creationDate: Option[Timestamp]
    def expirationDate: Option[Timestamp]
    def yesVoteCount: Option[VoteCount]
    def noVoteCount: Option[VoteCount]
    def outstandingVoteCount: Option[VoteCount]
    def tags: Option[Map[TagKey, TagValue]]
    def arn: Option[ArnString]
    def getProposalId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposalId", proposalId)
    def getNetworkId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getActions: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.ProposalActions.ReadOnly
    ] = AwsError.unwrapOptionField("actions", actions)
    def getProposedByMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposedByMemberId", proposedByMemberId)
    def getProposedByMemberName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("proposedByMemberName", proposedByMemberName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.ProposalStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getYesVoteCount: ZIO[Any, AwsError, VoteCount] =
      AwsError.unwrapOptionField("yesVoteCount", yesVoteCount)
    def getNoVoteCount: ZIO[Any, AwsError, VoteCount] =
      AwsError.unwrapOptionField("noVoteCount", noVoteCount)
    def getOutstandingVoteCount: ZIO[Any, AwsError, VoteCount] =
      AwsError.unwrapOptionField("outstandingVoteCount", outstandingVoteCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Proposal
  ) extends zio.aws.managedblockchain.model.Proposal.ReadOnly {
    override val proposalId: Option[ResourceIdString] = scala
      .Option(impl.proposalId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val networkId: Option[ResourceIdString] = scala
      .Option(impl.networkId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.DescriptionString(value)
      )
    override val actions
        : Option[zio.aws.managedblockchain.model.ProposalActions.ReadOnly] =
      scala
        .Option(impl.actions())
        .map(value =>
          zio.aws.managedblockchain.model.ProposalActions.wrap(value)
        )
    override val proposedByMemberId: Option[ResourceIdString] = scala
      .Option(impl.proposedByMemberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val proposedByMemberName: Option[NetworkMemberNameString] = scala
      .Option(impl.proposedByMemberName())
      .map(value =>
        zio.aws.managedblockchain.model.primitives
          .NetworkMemberNameString(value)
      )
    override val status
        : Option[zio.aws.managedblockchain.model.ProposalStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.managedblockchain.model.ProposalStatus.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val expirationDate: Option[Timestamp] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val yesVoteCount: Option[VoteCount] = scala
      .Option(impl.yesVoteCount())
      .map(value => zio.aws.managedblockchain.model.primitives.VoteCount(value))
    override val noVoteCount: Option[VoteCount] = scala
      .Option(impl.noVoteCount())
      .map(value => zio.aws.managedblockchain.model.primitives.VoteCount(value))
    override val outstandingVoteCount: Option[VoteCount] = scala
      .Option(impl.outstandingVoteCount())
      .map(value => zio.aws.managedblockchain.model.primitives.VoteCount(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Option[ArnString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Proposal
  ): zio.aws.managedblockchain.model.Proposal.ReadOnly = new Wrapper(impl)
}
