package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteNodeRequest(
    networkId: ResourceIdString,
    memberId: Option[ResourceIdString] = None,
    nodeId: ResourceIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest = {
    import DeleteNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .nodeId(ResourceIdString.unwrap(nodeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.DeleteNodeRequest.ReadOnly =
    zio.aws.managedblockchain.model.DeleteNodeRequest.wrap(buildAwsValue())
}
object DeleteNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.DeleteNodeRequest =
      zio.aws.managedblockchain.model
        .DeleteNodeRequest(networkId, memberId.map(value => value), nodeId)
    def networkId: ResourceIdString
    def memberId: Option[ResourceIdString]
    def nodeId: ResourceIdString
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getNodeId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(nodeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest
  ) extends zio.aws.managedblockchain.model.DeleteNodeRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: Option[ResourceIdString] = scala
      .Option(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val nodeId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives.ResourceIdString(impl.nodeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest
  ): zio.aws.managedblockchain.model.DeleteNodeRequest.ReadOnly = new Wrapper(
    impl
  )
}
