package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters.*
sealed trait VoteValue {
  def unwrap: software.amazon.awssdk.services.managedblockchain.model.VoteValue
}
object VoteValue {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.VoteValue
  ): zio.aws.managedblockchain.model.VoteValue = value match {
    case software.amazon.awssdk.services.managedblockchain.model.VoteValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.VoteValue.YES =>
      val r = YES
      r
    case software.amazon.awssdk.services.managedblockchain.model.VoteValue.NO =>
      val r = NO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.VoteValue {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.VoteValue =
      software.amazon.awssdk.services.managedblockchain.model.VoteValue.UNKNOWN_TO_SDK_VERSION
  }
  case object YES extends zio.aws.managedblockchain.model.VoteValue {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.VoteValue =
      software.amazon.awssdk.services.managedblockchain.model.VoteValue.YES
  }
  case object NO extends zio.aws.managedblockchain.model.VoteValue {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.VoteValue =
      software.amazon.awssdk.services.managedblockchain.model.VoteValue.NO
  }
}
