package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFrameworkAttributes(
    fabric: Option[zio.aws.managedblockchain.model.NetworkFabricAttributes] =
      None,
    ethereum: Option[
      zio.aws.managedblockchain.model.NetworkEthereumAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes = {
    import NetworkFrameworkAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .optionallyWith(ethereum.map(value => value.buildAwsValue()))(_.ethereum)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NetworkFrameworkAttributes
      .wrap(buildAwsValue())
}
object NetworkFrameworkAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NetworkFrameworkAttributes =
      zio.aws.managedblockchain.model.NetworkFrameworkAttributes(
        fabric.map(value => value.asEditable),
        ethereum.map(value => value.asEditable)
      )
    def fabric: Option[
      zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly
    ]
    def ethereum: Option[
      zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
    def getEthereum: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("ethereum", ethereum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
  ) extends zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly {
    override val fabric: Option[
      zio.aws.managedblockchain.model.NetworkFabricAttributes.ReadOnly
    ] = scala
      .Option(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkFabricAttributes.wrap(value)
      )
    override val ethereum: Option[
      zio.aws.managedblockchain.model.NetworkEthereumAttributes.ReadOnly
    ] = scala
      .Option(impl.ethereum())
      .map(value =>
        zio.aws.managedblockchain.model.NetworkEthereumAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes
  ): zio.aws.managedblockchain.model.NetworkFrameworkAttributes.ReadOnly =
    new Wrapper(impl)
}
