package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LogConfigurations(
    cloudwatch: Option[zio.aws.managedblockchain.model.LogConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.LogConfigurations = {
    import LogConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.LogConfigurations
      .builder()
      .optionallyWith(cloudwatch.map(value => value.buildAwsValue()))(
        _.cloudwatch
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.LogConfigurations.ReadOnly =
    zio.aws.managedblockchain.model.LogConfigurations.wrap(buildAwsValue())
}
object LogConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.LogConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.LogConfigurations =
      zio.aws.managedblockchain.model
        .LogConfigurations(cloudwatch.map(value => value.asEditable))
    def cloudwatch
        : Option[zio.aws.managedblockchain.model.LogConfiguration.ReadOnly]
    def getCloudwatch: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.LogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("cloudwatch", cloudwatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.LogConfigurations
  ) extends zio.aws.managedblockchain.model.LogConfigurations.ReadOnly {
    override val cloudwatch
        : Option[zio.aws.managedblockchain.model.LogConfiguration.ReadOnly] =
      scala
        .Option(impl.cloudwatch())
        .map(value =>
          zio.aws.managedblockchain.model.LogConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.LogConfigurations
  ): zio.aws.managedblockchain.model.LogConfigurations.ReadOnly = new Wrapper(
    impl
  )
}
