package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VotingPolicy(
    approvalThresholdPolicy: Option[
      zio.aws.managedblockchain.model.ApprovalThresholdPolicy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.VotingPolicy = {
    import VotingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.VotingPolicy
      .builder()
      .optionallyWith(
        approvalThresholdPolicy.map(value => value.buildAwsValue())
      )(_.approvalThresholdPolicy)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.VotingPolicy.ReadOnly =
    zio.aws.managedblockchain.model.VotingPolicy.wrap(buildAwsValue())
}
object VotingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.VotingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.VotingPolicy =
      zio.aws.managedblockchain.model
        .VotingPolicy(approvalThresholdPolicy.map(value => value.asEditable))
    def approvalThresholdPolicy: Option[
      zio.aws.managedblockchain.model.ApprovalThresholdPolicy.ReadOnly
    ]
    def getApprovalThresholdPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.ApprovalThresholdPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalThresholdPolicy",
      approvalThresholdPolicy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.VotingPolicy
  ) extends zio.aws.managedblockchain.model.VotingPolicy.ReadOnly {
    override val approvalThresholdPolicy: Option[
      zio.aws.managedblockchain.model.ApprovalThresholdPolicy.ReadOnly
    ] = scala
      .Option(impl.approvalThresholdPolicy())
      .map(value =>
        zio.aws.managedblockchain.model.ApprovalThresholdPolicy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.VotingPolicy
  ): zio.aws.managedblockchain.model.VotingPolicy.ReadOnly = new Wrapper(impl)
}
