package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveAction(memberId: ResourceIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.RemoveAction = {
    import RemoveAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.RemoveAction
      .builder()
      .memberId(ResourceIdString.unwrap(memberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.RemoveAction.ReadOnly =
    zio.aws.managedblockchain.model.RemoveAction.wrap(buildAwsValue())
}
object RemoveAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.RemoveAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.RemoveAction =
      zio.aws.managedblockchain.model.RemoveAction(memberId)
    def memberId: ResourceIdString
    def getMemberId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.RemoveAction
  ) extends zio.aws.managedblockchain.model.RemoveAction.ReadOnly {
    override val memberId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.memberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.RemoveAction
  ): zio.aws.managedblockchain.model.RemoveAction.ReadOnly = new Wrapper(impl)
}
