package zio.aws.managedblockchain.model
import java.lang.Integer
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  ProposalListMaxResults,
  ResourceIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProposalVotesRequest(
    networkId: ResourceIdString,
    proposalId: ResourceIdString,
    maxResults: Option[ProposalListMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest = {
    import ListProposalVotesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .proposalId(ResourceIdString.unwrap(proposalId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ProposalListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListProposalVotesRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListProposalVotesRequest
      .wrap(buildAwsValue())
}
object ListProposalVotesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListProposalVotesRequest =
      zio.aws.managedblockchain.model.ListProposalVotesRequest(
        networkId,
        proposalId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkId: ResourceIdString
    def proposalId: ResourceIdString
    def maxResults: Option[ProposalListMaxResults]
    def nextToken: Option[PaginationToken]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getProposalId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(proposalId)
    def getMaxResults: ZIO[Any, AwsError, ProposalListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest
  ) extends zio.aws.managedblockchain.model.ListProposalVotesRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val proposalId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.proposalId())
    override val maxResults: Option[ProposalListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ProposalListMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest
  ): zio.aws.managedblockchain.model.ListProposalVotesRequest.ReadOnly =
    new Wrapper(impl)
}
