package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NodeEthereumAttributes(
    httpEndpoint: Option[String] = None,
    webSocketEndpoint: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeEthereumAttributes = {
    import NodeEthereumAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeEthereumAttributes
      .builder()
      .optionallyWith(httpEndpoint.map(value => value: java.lang.String))(
        _.httpEndpoint
      )
      .optionallyWith(webSocketEndpoint.map(value => value: java.lang.String))(
        _.webSocketEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.NodeEthereumAttributes.ReadOnly =
    zio.aws.managedblockchain.model.NodeEthereumAttributes.wrap(buildAwsValue())
}
object NodeEthereumAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeEthereumAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NodeEthereumAttributes =
      zio.aws.managedblockchain.model.NodeEthereumAttributes(
        httpEndpoint.map(value => value),
        webSocketEndpoint.map(value => value)
      )
    def httpEndpoint: Option[String]
    def webSocketEndpoint: Option[String]
    def getHttpEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getWebSocketEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webSocketEndpoint", webSocketEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeEthereumAttributes
  ) extends zio.aws.managedblockchain.model.NodeEthereumAttributes.ReadOnly {
    override val httpEndpoint: Option[String] =
      scala.Option(impl.httpEndpoint()).map(value => value: String)
    override val webSocketEndpoint: Option[String] =
      scala.Option(impl.webSocketEndpoint()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeEthereumAttributes
  ): zio.aws.managedblockchain.model.NodeEthereumAttributes.ReadOnly =
    new Wrapper(impl)
}
