package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProposalResponse(
    proposalId: Optional[ResourceIdString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse = {
    import CreateProposalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse
      .builder()
      .optionallyWith(
        proposalId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.proposalId)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly =
    zio.aws.managedblockchain.model.CreateProposalResponse.wrap(buildAwsValue())
}
object CreateProposalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateProposalResponse =
      zio.aws.managedblockchain.model
        .CreateProposalResponse(proposalId.map(value => value))
    def proposalId: Optional[ResourceIdString]
    def getProposalId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("proposalId", proposalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse
  ) extends zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly {
    override val proposalId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.proposalId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse
  ): zio.aws.managedblockchain.model.CreateProposalResponse.ReadOnly =
    new Wrapper(impl)
}
