package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  ArnString,
  Timestamp,
  ResourceIdString
}
import scala.jdk.CollectionConverters._
final case class Invitation(
    invitationId: Optional[ResourceIdString] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.InvitationStatus] =
      Optional.Absent,
    networkSummary: Optional[zio.aws.managedblockchain.model.NetworkSummary] =
      Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Invitation = {
    import Invitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Invitation
      .builder()
      .optionallyWith(
        invitationId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.invitationId)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(networkSummary.map(value => value.buildAwsValue()))(
        _.networkSummary
      )
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Invitation.ReadOnly =
    zio.aws.managedblockchain.model.Invitation.wrap(buildAwsValue())
}
object Invitation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Invitation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Invitation =
      zio.aws.managedblockchain.model.Invitation(
        invitationId.map(value => value),
        creationDate.map(value => value),
        expirationDate.map(value => value),
        status.map(value => value),
        networkSummary.map(value => value.asEditable),
        arn.map(value => value)
      )
    def invitationId: Optional[ResourceIdString]
    def creationDate: Optional[Timestamp]
    def expirationDate: Optional[Timestamp]
    def status: Optional[zio.aws.managedblockchain.model.InvitationStatus]
    def networkSummary
        : Optional[zio.aws.managedblockchain.model.NetworkSummary.ReadOnly]
    def arn: Optional[ArnString]
    def getInvitationId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("invitationId", invitationId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.InvitationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNetworkSummary: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NetworkSummary.ReadOnly
    ] = AwsError.unwrapOptionField("networkSummary", networkSummary)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Invitation
  ) extends zio.aws.managedblockchain.model.Invitation.ReadOnly {
    override val invitationId: Optional[ResourceIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitationId())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.managedblockchain.model.InvitationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.managedblockchain.model.InvitationStatus.wrap(value)
        )
    override val networkSummary
        : Optional[zio.aws.managedblockchain.model.NetworkSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSummary())
        .map(value =>
          zio.aws.managedblockchain.model.NetworkSummary.wrap(value)
        )
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Invitation
  ): zio.aws.managedblockchain.model.Invitation.ReadOnly = new Wrapper(impl)
}
