package zio.aws.managedblockchain.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  Timestamp,
  TagValue,
  ResourceIdString,
  AvailabilityZoneString,
  InstanceTypeString,
  ArnString,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class Node(
    networkId: Optional[ResourceIdString] = Optional.Absent,
    memberId: Optional[ResourceIdString] = Optional.Absent,
    id: Optional[ResourceIdString] = Optional.Absent,
    instanceType: Optional[InstanceTypeString] = Optional.Absent,
    availabilityZone: Optional[AvailabilityZoneString] = Optional.Absent,
    frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.NodeFrameworkAttributes
    ] = Optional.Absent,
    logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
    ] = Optional.Absent,
    stateDB: Optional[zio.aws.managedblockchain.model.StateDBType] =
      Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.NodeStatus] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    arn: Optional[ArnString] = Optional.Absent,
    kmsKeyArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.Node
      .builder()
      .optionallyWith(
        networkId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.networkId)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .optionallyWith(
        id.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        instanceType.map(value =>
          InstanceTypeString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZoneString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(frameworkAttributes.map(value => value.buildAwsValue()))(
        _.frameworkAttributes
      )
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .optionallyWith(stateDB.map(value => value.unwrap))(_.stateDB)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        arn.map(value => ArnString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.Node.ReadOnly =
    zio.aws.managedblockchain.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.Node
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.Node =
      zio.aws.managedblockchain.model.Node(
        networkId.map(value => value),
        memberId.map(value => value),
        id.map(value => value),
        instanceType.map(value => value),
        availabilityZone.map(value => value),
        frameworkAttributes.map(value => value.asEditable),
        logPublishingConfiguration.map(value => value.asEditable),
        stateDB.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        tags.map(value => value),
        arn.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def networkId: Optional[ResourceIdString]
    def memberId: Optional[ResourceIdString]
    def id: Optional[ResourceIdString]
    def instanceType: Optional[InstanceTypeString]
    def availabilityZone: Optional[AvailabilityZoneString]
    def frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.NodeFrameworkAttributes.ReadOnly
    ]
    def logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ]
    def stateDB: Optional[zio.aws.managedblockchain.model.StateDBType]
    def status: Optional[zio.aws.managedblockchain.model.NodeStatus]
    def creationDate: Optional[Timestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def arn: Optional[ArnString]
    def kmsKeyArn: Optional[String]
    def getNetworkId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("id", id)
    def getInstanceType: ZIO[Any, AwsError, InstanceTypeString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZoneString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getFrameworkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeFrameworkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("frameworkAttributes", frameworkAttributes)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
    def getStateDB
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.StateDBType] =
      AwsError.unwrapOptionField("stateDB", stateDB)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.NodeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArn: ZIO[Any, AwsError, ArnString] =
      AwsError.unwrapOptionField("arn", arn)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.Node
  ) extends zio.aws.managedblockchain.model.Node.ReadOnly {
    override val networkId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.networkId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val memberId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val id: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val instanceType: Optional[InstanceTypeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.InstanceTypeString(value)
        )
    override val availabilityZone: Optional[AvailabilityZoneString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .AvailabilityZoneString(value)
        )
    override val frameworkAttributes: Optional[
      zio.aws.managedblockchain.model.NodeFrameworkAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkAttributes())
      .map(value =>
        zio.aws.managedblockchain.model.NodeFrameworkAttributes.wrap(value)
      )
    override val logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
          .wrap(value)
      )
    override val stateDB
        : Optional[zio.aws.managedblockchain.model.StateDBType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateDB())
        .map(value => zio.aws.managedblockchain.model.StateDBType.wrap(value))
    override val status: Optional[zio.aws.managedblockchain.model.NodeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.managedblockchain.model.NodeStatus.wrap(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.managedblockchain.model.primitives.Timestamp(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val arn: Optional[ArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.managedblockchain.model.primitives.ArnString(value))
    override val kmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.Node
  ): zio.aws.managedblockchain.model.Node.ReadOnly = new Wrapper(impl)
}
