package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemberLogPublishingConfiguration(
    fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration = {
    import MemberLogPublishingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
      .wrap(buildAwsValue())
}
object MemberLogPublishingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchain.model.MemberLogPublishingConfiguration =
      zio.aws.managedblockchain.model
        .MemberLogPublishingConfiguration(fabric.map(value => value.asEditable))
    def fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration
  ) extends zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly {
    override val fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.MemberFabricLogPublishingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration
  ): zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly =
    new Wrapper(impl)
}
