package zio.aws.managedblockchain.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  AccessorListMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAccessorsRequest(
    maxResults: Optional[AccessorListMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest = {
    import ListAccessorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => AccessorListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListAccessorsRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListAccessorsRequest.wrap(buildAwsValue())
}
object ListAccessorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListAccessorsRequest =
      zio.aws.managedblockchain.model.ListAccessorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[AccessorListMaxResults]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, AccessorListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest
  ) extends zio.aws.managedblockchain.model.ListAccessorsRequest.ReadOnly {
    override val maxResults: Optional[AccessorListMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .AccessorListMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest
  ): zio.aws.managedblockchain.model.ListAccessorsRequest.ReadOnly =
    new Wrapper(impl)
}
