package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ClientRequestTokenString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAccessorRequest(
    clientRequestToken: ClientRequestTokenString,
    accessorType: zio.aws.managedblockchain.model.AccessorType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest = {
    import CreateAccessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
      .builder()
      .clientRequestToken(
        ClientRequestTokenString.unwrap(clientRequestToken): java.lang.String
      )
      .accessorType(accessorType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateAccessorRequest.ReadOnly =
    zio.aws.managedblockchain.model.CreateAccessorRequest.wrap(buildAwsValue())
}
object CreateAccessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateAccessorRequest =
      zio.aws.managedblockchain.model
        .CreateAccessorRequest(clientRequestToken, accessorType)
    def clientRequestToken: ClientRequestTokenString
    def accessorType: zio.aws.managedblockchain.model.AccessorType
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestTokenString] =
      ZIO.succeed(clientRequestToken)
    def getAccessorType
        : ZIO[Any, Nothing, zio.aws.managedblockchain.model.AccessorType] =
      ZIO.succeed(accessorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
  ) extends zio.aws.managedblockchain.model.CreateAccessorRequest.ReadOnly {
    override val clientRequestToken: ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives
        .ClientRequestTokenString(impl.clientRequestToken())
    override val accessorType: zio.aws.managedblockchain.model.AccessorType =
      zio.aws.managedblockchain.model.AccessorType.wrap(impl.accessorType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
  ): zio.aws.managedblockchain.model.CreateAccessorRequest.ReadOnly =
    new Wrapper(impl)
}
