package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccessorsResponse(
    accessors: Optional[
      Iterable[zio.aws.managedblockchain.model.AccessorSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse = {
    import ListAccessorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse
      .builder()
      .optionallyWith(
        accessors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessors)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListAccessorsResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListAccessorsResponse.wrap(buildAwsValue())
}
object ListAccessorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListAccessorsResponse =
      zio.aws.managedblockchain.model.ListAccessorsResponse(
        accessors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accessors: Optional[
      List[zio.aws.managedblockchain.model.AccessorSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getAccessors: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.AccessorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("accessors", accessors)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse
  ) extends zio.aws.managedblockchain.model.ListAccessorsResponse.ReadOnly {
    override val accessors: Optional[
      List[zio.aws.managedblockchain.model.AccessorSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchain.model.AccessorSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse
  ): zio.aws.managedblockchain.model.ListAccessorsResponse.ReadOnly =
    new Wrapper(impl)
}
