package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNodesResponse(
    nodes: Optional[Iterable[zio.aws.managedblockchain.model.NodeSummary]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse = {
    import ListNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse
      .builder()
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListNodesResponse.wrap(buildAwsValue())
}
object ListNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListNodesResponse =
      zio.aws.managedblockchain.model.ListNodesResponse(
        nodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def nodes
        : Optional[List[zio.aws.managedblockchain.model.NodeSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getNodes: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.NodeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("nodes", nodes)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse
  ) extends zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly {
    override val nodes
        : Optional[List[zio.aws.managedblockchain.model.NodeSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.managedblockchain.model.NodeSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse
  ): zio.aws.managedblockchain.model.ListNodesResponse.ReadOnly = new Wrapper(
    impl
  )
}
