package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  TagValue,
  TagKey,
  ResourceIdString,
  ClientRequestTokenString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNodeRequest(
    clientRequestToken: ClientRequestTokenString,
    networkId: ResourceIdString,
    memberId: Optional[ResourceIdString] = Optional.Absent,
    nodeConfiguration: zio.aws.managedblockchain.model.NodeConfiguration,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest = {
    import CreateNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest
      .builder()
      .clientRequestToken(
        ClientRequestTokenString.unwrap(clientRequestToken): java.lang.String
      )
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .nodeConfiguration(nodeConfiguration.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.CreateNodeRequest.ReadOnly =
    zio.aws.managedblockchain.model.CreateNodeRequest.wrap(buildAwsValue())
}
object CreateNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateNodeRequest =
      zio.aws.managedblockchain.model.CreateNodeRequest(
        clientRequestToken,
        networkId,
        memberId.map(value => value),
        nodeConfiguration.asEditable,
        tags.map(value => value)
      )
    def clientRequestToken: ClientRequestTokenString
    def networkId: ResourceIdString
    def memberId: Optional[ResourceIdString]
    def nodeConfiguration
        : zio.aws.managedblockchain.model.NodeConfiguration.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestTokenString] =
      ZIO.succeed(clientRequestToken)
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getNodeConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchain.model.NodeConfiguration.ReadOnly
    ] = ZIO.succeed(nodeConfiguration)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest
  ) extends zio.aws.managedblockchain.model.CreateNodeRequest.ReadOnly {
    override val clientRequestToken: ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives
        .ClientRequestTokenString(impl.clientRequestToken())
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val nodeConfiguration
        : zio.aws.managedblockchain.model.NodeConfiguration.ReadOnly =
      zio.aws.managedblockchain.model.NodeConfiguration
        .wrap(impl.nodeConfiguration())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest
  ): zio.aws.managedblockchain.model.CreateNodeRequest.ReadOnly = new Wrapper(
    impl
  )
}
